<?php

use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\BrandController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ColorController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SizeController;
use App\Http\Controllers\SubcategoryController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\UserAuthController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SalesController; // Added this for sales
use App\Http\Controllers\SupplierController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| User Routes
|--------------------------------------------------------------------------
*/
Route::prefix('public')->group(function () {
    // Banner Routes
    Route::prefix('banner')->group(function () {
        Route::get('/', [BannerController::class, 'index']);
        Route::get('/{id}', [BannerController::class, 'show']);
    });

    // Category Routes
    Route::prefix('category')->group(function () {
        Route::get('/', [CategoryController::class, 'index']);
        Route::get('/{id}', [CategoryController::class, 'show']);
    });

    // Subcategory Routes
    Route::prefix('subcategory')->group(function () {
        Route::get('/', [SubcategoryController::class, 'index']);
        Route::get('/{id}', [SubcategoryController::class, 'show']);
    });

    // Color Routes
    Route::prefix('color')->group(function () {
        Route::get('/', [ColorController::class, 'index']);
        Route::get('/{id}', [ColorController::class, 'show']);
    });

    // Contact Routes
    Route::prefix('contact')->group(function () {
        Route::post('/', [ContactController::class, 'store']);
    });

    // Brand Routes
    Route::prefix('brand')->group(function () {
        Route::get('/', [BrandController::class, 'index']);
        Route::get('/{id}', [BrandController::class, 'show']);
    });

    // Unit Routes
    Route::prefix('unit')->group(function () {
        Route::get('/', [UnitController::class, 'index']);
        Route::get('/{id}', [UnitController::class, 'show']);
    });

    // Size Routes
    Route::prefix('size')->group(function () {
        Route::get('/', [SizeController::class, 'index']);
        Route::get('/{id}', [SizeController::class, 'show']);
    });

    // Product Routes
    Route::prefix('product')->group(function () {
        Route::get('/', [ProductController::class, 'index']);
        Route::get('/{sku}', [ProductController::class, 'show']);
    });


});

Route::post('/login', [UserAuthController::class, 'login']);

/*
|--------------------------------------------------------------------------
| User Routes
|--------------------------------------------------------------------------
*/
Route::prefix('user')->group(function () {
    Route::post('/register', [UserAuthController::class, 'register']);
    Route::post('/login', [UserAuthController::class, 'login']);
    Route::post('/send-otp', [UserAuthController::class, 'sendOtp']);
    Route::post('/verify-otp', [UserAuthController::class, 'verifyOtp']);
    Route::post('/reset-password', [UserAuthController::class, 'resetPassword']);

    Route::middleware(['auth:user', 'check.token'])->group(function () {
        Route::get('/profile', [UserAuthController::class, 'profile']);
        Route::post('/profile', [UserAuthController::class, 'updateProfile']);
        Route::post('/logout', [UserAuthController::class, 'logout']);
        // Add more protected user routes here
    });
});

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
*/
Route::prefix('admin')->group(function () {
    Route::post('/register', [AdminAuthController::class, 'register']);
    Route::post('/login', [AdminAuthController::class, 'login']);
    Route::post('/send-otp', [AdminAuthController::class, 'sendOtp']);
    Route::post('/verify-otp', [AdminAuthController::class, 'verifyOtp']);
    Route::post('/reset-password', [AdminAuthController::class, 'resetPassword']);

    Route::middleware(['auth:admin', 'check.token'])->group(function () {
        Route::get('/profile', [AdminAuthController::class, 'profile']);
        Route::post('/profile', [AdminAuthController::class, 'updateProfile']);
        Route::post('/logout', [AdminAuthController::class, 'logout']);

        // Banner Management
        Route::prefix('banner')->group(function () {
            Route::post('/', [BannerController::class, 'store']);
            Route::post('/{id}', [BannerController::class, 'update']);
            Route::delete('/{id}', [BannerController::class, 'destroy']);
        });

        // Category Management
        Route::prefix('category')->group(function () {
            Route::post('/', [CategoryController::class, 'store']);
            Route::post('/{id}', [CategoryController::class, 'update']);
            Route::delete('/{id}', [CategoryController::class, 'destroy']);
        });

        // Subcategory Management
        Route::prefix('subcategory')->group(function () {
            Route::post('/', [SubcategoryController::class, 'store']);
            Route::post('/{id}', [SubcategoryController::class, 'update']);
            Route::delete('/{id}', [SubcategoryController::class, 'destroy']);
        });

        // Color Management
        Route::prefix('color')->group(function () {
            Route::post('/', [ColorController::class, 'store']);
            Route::post('/{id}', [ColorController::class, 'update']);
            Route::delete('/{id}', [ColorController::class, 'destroy']);
        });

        // Contact Management
        Route::prefix('contact')->group(function () {
            Route::get('/', [ContactController::class, 'index']);
            Route::get('/{id}', [ContactController::class, 'show']);
            Route::post('/{id}', [ContactController::class, 'update']);
            Route::delete('/{id}', [ContactController::class, 'destroy']);
        });

        // Brand Management
        Route::prefix('brand')->group(function () {
            Route::post('/', [BrandController::class, 'store']);
            Route::post('/{id}', [BrandController::class, 'update']);
            Route::delete('/{id}', [BrandController::class, 'destroy']);
        });

        // Unit Management
        Route::prefix('unit')->group(function () {
            Route::post('/', [UnitController::class, 'store']);
            Route::post('/{id}', [UnitController::class, 'update']);
            Route::delete('/{id}', [UnitController::class, 'destroy']);
        });

        // Size Management
        Route::prefix('size')->group(function () {
            Route::post('/', [SizeController::class, 'store']);
            Route::post('/{id}', [SizeController::class, 'update']);
            Route::delete('/{id}', [SizeController::class, 'destroy']);
        });

        // Product Management
        Route::prefix('product')->group(function () {
            Route::post('/', [ProductController::class, 'store']);
            Route::post('/{id}', [ProductController::class, 'update']);
            Route::delete('/{id}', [ProductController::class, 'destroy']);
        });

        // Customer Management
        Route::prefix('customer')->group(function () {
            Route::get('/', [CustomerController::class, 'index']); // admin view all customers
            Route::get('/{id}', [CustomerController::class, 'show']); // admin show one customer
            Route::post('/', [CustomerController::class, 'store']); // admin create customer
            Route::post('/{id}', [CustomerController::class, 'update']); // admin update customer
            Route::delete('/{id}', [CustomerController::class, 'destroy']); // admin delete customer
        });

        // Sales Management (Admin protected)
        Route::prefix('sales')->group(function () {
            Route::get('/', [SalesController::class, 'index']);             // Admin list all sales
            Route::get('/{id}', [SalesController::class, 'show']);          // Admin show a sale
            Route::post('/', [SalesController::class, 'store']);            // Admin create a sale
            Route::post('/{id}', [SalesController::class, 'update']);       // Admin update a sale
            Route::delete('/{id}', [SalesController::class, 'destroy']);    // Admin delete a sale
        });

        // Purchase Management (Admin protected)
        Route::prefix('purchase')->group(function () {
            Route::get('/', [PurchaseController::class, 'index']);             // Admin list all purchases
            Route::get('/{id}', [PurchaseController::class, 'show']);          // Admin show a purchase
            Route::post('/', [PurchaseController::class, 'store']);            // Admin create a purchase
            Route::post('/{id}', [PurchaseController::class, 'update']);       // Admin update a purchase
            Route::delete('/{id}', [PurchaseController::class, 'destroy']);    // Admin delete a purchase
        });

        // Expense Management (Admin protected)
        Route::prefix('expense')->group(function () {
            Route::get('/', [ExpenseController::class, 'index']);              // Admin list all expenses
            Route::get('/{id}', [ExpenseController::class, 'show']);           // Admin show an expense
            Route::post('/', [ExpenseController::class, 'store']);             // Admin create an expense
            Route::post('/{id}', [ExpenseController::class, 'update']);        // Admin update an expense
            Route::delete('/{id}', [ExpenseController::class, 'destroy']);     // Admin delete an expense
        });

        // Supplier Management (Admin protected)
        Route::prefix('supplier')->group(function () {
            Route::get('/', [SupplierController::class, 'index']);             // Admin list all suppliers
            Route::get('/{id}', [SupplierController::class, 'show']);          // Admin show a supplier
            Route::post('/', [SupplierController::class, 'store']);            // Admin create a supplier
            Route::post('/{id}', [SupplierController::class, 'update']);       // Admin update a supplier
            Route::delete('/{id}', [SupplierController::class, 'destroy']);    // Admin delete a supplier
        });

        // Reports Management (Admin protected)
        Route::prefix('report')->group(function () {
            Route::get('/stock', [ReportController::class, 'stock']);           // Stock report with filters
            Route::get('/profit-loss', [ReportController::class, 'profitLoss']);        // Profit and loss report (GET with filters)
        });

        Route::get('/dashboard', [\App\Http\Controllers\DashboardController::class, 'index']);

        // Permission-based routes
        Route::middleware('admin.permission:create_user')->get('/create-user', function () {
            return response()->json(['message' => 'You have create_user permission']);
        });

        Route::middleware('admin.permission:delete_user')->delete('/delete-user', function () {
            return response()->json(['message' => 'You have delete_user permission']);
        });

        Route::get('/users', [\App\Http\Controllers\UserController::class, 'index']);


        // Add more admin protected routes here
    });
});

