<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Unit;

class UnitSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $units = [
            [
                'name' => 'Piece',
                'short_name' => 'pc',
                'description' => 'Individual piece/unit',
                'status' => 'active',
            ],
            [
                'name' => 'Kilogram',
                'short_name' => 'kg',
                'description' => 'Kilogram unit',
                'status' => 'active',
            ],
            [
                'name' => 'Gram',
                'short_name' => 'g',
                'description' => 'Gram unit',
                'status' => 'active',
            ],
            [
                'name' => 'Meter',
                'short_name' => 'm',
                'description' => 'Meter unit',
                'status' => 'active',
            ],
            [
                'name' => 'Centimeter',
                'short_name' => 'cm',
                'description' => 'Centimeter unit',
                'status' => 'active',
            ],
            [
                'name' => 'Liter',
                'short_name' => 'l',
                'description' => 'Liter unit',
                'status' => 'active',
            ],
            [
                'name' => 'Milliliter',
                'short_name' => 'ml',
                'description' => 'Milliliter unit',
                'status' => 'active',
            ],
            [
                'name' => 'Box',
                'short_name' => 'box',
                'description' => 'Box packaging unit',
                'status' => 'active',
            ],
            [
                'name' => 'Pack',
                'short_name' => 'pack',
                'description' => 'Pack packaging unit',
                'status' => 'active',
            ],
            [
                'name' => 'Dozen',
                'short_name' => 'doz',
                'description' => 'Twelve pieces per unit',
                'status' => 'active',
            ],
        ];

        foreach ($units as $unit) {
            Unit::create($unit);
        }
    }
}
