<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Subcategory;

class SubcategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $subcategories = [
            [
                'category_id' => 1,
                'name' => 'T-Shirts',
                'description' => 'Short and long sleeve tees.',
                'image' => 'subcategories/subcategory-1.jpg',
                'status' => 'active',
            ],
            [
                'category_id' => 1,
                'name' => 'Shirts',
                'description' => 'Formal and casual shirts.',
                'image' => 'subcategories/subcategory-2.jpg',
                'status' => 'active',
            ],
            [
                'category_id' => 2,
                'name' => 'Jeans',
                'description' => 'Denim and regular jeans.',
                'image' => 'subcategories/subcategory-3.jpg',
                'status' => 'active',
            ],
            [
                'category_id' => 2,
                'name' => 'Shorts',
                'description' => 'Casual and sports shorts.',
                'image' => 'subcategories/subcategory-4.jpg',
                'status' => 'active',
            ],
            [
                'category_id' => 3,
                'name' => 'Sneakers',
                'description' => 'All types of sneakers.',
                'image' => 'subcategories/subcategory-5.jpg',
                'status' => 'active',
            ],
            [
                'category_id' => 3,
                'name' => 'Sandals',
                'description' => 'Summer and beach sandals.',
                'image' => 'subcategories/subcategory-6.jpg',
                'status' => 'active',
            ],
            [
                'category_id' => 4,
                'name' => 'Handbags',
                'description' => 'Fashion and utility handbags.',
                'image' => 'subcategories/subcategory-7.jpg',
                'status' => 'active',
            ],
            [
                'category_id' => 4,
                'name' => 'Backpacks',
                'description' => 'Travel and school backpacks.',
                'image' => 'subcategories/subcategory-8.jpg',
                'status' => 'active',
            ],
            [
                'category_id' => 5,
                'name' => 'Watches',
                'description' => 'Men and women wrist watches.',
                'image' => 'subcategories/subcategory-9.jpg',
                'status' => 'active',
            ],
            [
                'category_id' => 5,
                'name' => 'Jewellery',
                'description' => 'Necklaces, rings, and more.',
                'image' => 'subcategories/subcategory-10.jpg',
                'status' => 'active',
            ],
        ];

        foreach ($subcategories as $subcategory) {
            Subcategory::create($subcategory);
        }
    }
}
