<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Size;

class SizeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Seeder for 10 standard size rows based on common use-cases
        $sizes = [
            [
                'name' => 'XS',
                'code' => 'XS',
                'description' => 'Extra Small size, commonly for petite body builds.',
                'status' => 'active',
            ],
            [
                'name' => 'S',
                'code' => 'S',
                'description' => 'Small size for lean body builds.',
                'status' => 'active',
            ],
            [
                'name' => 'M',
                'code' => 'M',
                'description' => 'Medium size, fits most average adults.',
                'status' => 'active',
            ],
            [
                'name' => 'L',
                'code' => 'L',
                'description' => 'Large size for slightly larger body builds.',
                'status' => 'active',
            ],
            [
                'name' => 'XL',
                'code' => 'XL',
                'description' => 'Extra Large size, for broader body types.',
                'status' => 'active',
            ],
            [
                'name' => 'XXL',
                'code' => 'XXL',
                'description' => 'Double Extra Large, accommodates bigger sizes.',
                'status' => 'active',
            ],
            [
                'name' => 'XXXL',
                'code' => 'XXXL',
                'description' => 'Triple Extra Large, suitable for big & tall builds.',
                'status' => 'inactive',
            ],
            [
                'name' => '4XL',
                'code' => '4XL',
                'description' => 'Quadruple Extra Large, rare extended size.',
                'status' => 'inactive',
            ],
            [
                'name' => '5XL',
                'code' => '5XL',
                'description' => 'Quintuple Extra Large, special order.',
                'status' => 'inactive',
            ],
            [
                'name' => '6XL',
                'code' => '6XL',
                'description' => 'Six times Extra Large, largest available in standard chart.',
                'status' => 'inactive',
            ],
        ];

        foreach ($sizes as $size) {
            Size::create($size);
        }
    }
}
