<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Unit;
use App\Models\Color;
use App\Models\Size;
use Carbon\Carbon;

class ProductSeeder extends Seeder
{
    public function run()
    {
        $categoryIds = Category::pluck('id')->toArray();
        $brandIds = Brand::pluck('id')->toArray();
        $unitIds = Unit::pluck('id')->toArray();
        $colorIds = Color::pluck('id')->toArray();
        $sizeIds = Size::pluck('id')->toArray();

        $products = [
            [
                'name'            => 'Ultra Phone X1',
                'sku'             => 'SKU-001',
                'barcode'         => '1234567890123',
                'image'           => 'products/sample-1.jpg',
                'cat_id'          => $categoryIds[0] ?? null,
                'brand_id'        => $brandIds[0] ?? null,
                'unit_id'         => $unitIds[0] ?? null,
                'color_id'        => $colorIds[0] ?? null,
                'purchase_price'  => 350.00,
                'discount'        => 5.00,
                'tax'             => 10.00,
                'price'           => 499,
                'offer_price'     => 449,
                'stock'           => 20,
                'alert_quantity'  => 5,
                'weight'          => '0.18 kg',
                'size_id'         => isset($sizeIds[0]) ? $sizeIds[0] : null,
                'material'        => 'Aluminum',
                'origin'          => 'China',
                'description'     => 'High performance smartphone with cutting-edge features.',
                'gallery_images'  => json_encode(['products/gallery/sample-1.jpg', 'products/gallery/sample-2.jpg']),
                'extra_status'    => 'featured',
                'status'          => 'active',
                'created_at'      => Carbon::now(),
                'updated_at'      => Carbon::now(),
            ],
            [
                'name'            => 'Pro Bluetooth Headphones',
                'sku'             => 'SKU-002',
                'barcode'         => '2345678901234',
                'image'           => 'products/sample-2.jpg',
                'cat_id'          => $categoryIds[1] ?? null,
                'brand_id'        => $brandIds[1] ?? null,
                'unit_id'         => $unitIds[1] ?? null,
                'color_id'        => $colorIds[1] ?? null,
                'purchase_price'  => 80.00,
                'discount'        => 3.00,
                'tax'             => 8.00,
                'price'           => 129,
                'offer_price'     => 99,
                'stock'           => 50,
                'alert_quantity'  => 10,
                'weight'          => '0.25 kg',
                'size_id'         => isset($sizeIds[1]) ? $sizeIds[1] : null,
                'material'        => 'Plastic',
                'origin'          => 'USA',
                'description'     => 'Over-ear wireless headphones with noise cancellation.',
                'gallery_images'  => json_encode(['products/gallery/sample-3.jpg']),
                'extra_status'    => 'featured',
                'status'          => 'active',
                'created_at'      => Carbon::now(),
                'updated_at'      => Carbon::now(),
            ],
            [
                'name'            => 'Stainless Kitchen Mixer',
                'sku'             => 'SKU-003',
                'barcode'         => '3456789012345',
                'image'           => 'products/sample-3.jpg',
                'cat_id'          => $categoryIds[2] ?? null,
                'brand_id'        => $brandIds[2] ?? null,
                'unit_id'         => $unitIds[2] ?? null,
                'color_id'        => $colorIds[2] ?? null,
                'purchase_price'  => 200.00,
                'discount'        => 4.00,
                'tax'             => 12.00,
                'price'           => 299,
                'offer_price'     => 249,
                'stock'           => 10,
                'alert_quantity'  => 3,
                'weight'          => '4.50 kg',
                'size_id'         => isset($sizeIds[2]) ? $sizeIds[2] : null,
                'material'        => 'Stainless Steel',
                'origin'          => 'Germany',
                'description'     => 'Multipurpose kitchen mixer with multiple attachments.',
                'gallery_images'  => json_encode(['products/gallery/sample-4.jpg', 'products/gallery/sample-5.jpg']),
                'extra_status'    => 'hot',
                'status'          => 'active',
                'created_at'      => Carbon::now(),
                'updated_at'      => Carbon::now(),
            ],
            [
                'name'            => 'Classic Leather Wallet',
                'sku'             => 'SKU-004',
                'barcode'         => '4567890123456',
                'image'           => 'products/sample-4.jpg',
                'cat_id'          => $categoryIds[3] ?? null,
                'brand_id'        => $brandIds[3] ?? null,
                'unit_id'         => $unitIds[3] ?? null,
                'color_id'        => $colorIds[3] ?? null,
                'purchase_price'  => 35.00,
                'discount'        => 2.00,
                'tax'             => 5.00,
                'price'           => 59,
                'offer_price'     => 45,
                'stock'           => 70,
                'alert_quantity'  => 15,
                'weight'          => '0.15 kg',
                'size_id'         => isset($sizeIds[3]) ? $sizeIds[3] : null,
                'material'        => 'Leather',
                'origin'          => 'Italy',
                'description'     => 'Premium classic wallet for men and women.',
                'gallery_images'  => json_encode(['products/gallery/sample-1.jpg']),
                'extra_status'    => 'hot',
                'status'          => 'active',
                'created_at'      => Carbon::now(),
                'updated_at'      => Carbon::now(),
            ],
            [
                'name'            => 'Kids Toy Car',
                'sku'             => 'SKU-005',
                'barcode'         => '5678901234567',
                'image'           => 'products/sample-5.jpg',
                'cat_id'          => $categoryIds[4] ?? null,
                'brand_id'        => $brandIds[4] ?? null,
                'unit_id'         => $unitIds[4] ?? null,
                'color_id'        => $colorIds[4] ?? null,
                'purchase_price'  => 20.00,
                'discount'        => 1.00,
                'tax'             => 3.00,
                'price'           => 39,
                'offer_price'     => 29,
                'stock'           => 100,
                'alert_quantity'  => 20,
                'weight'          => '0.95 kg',
                'size_id'         => isset($sizeIds[4]) ? $sizeIds[4] : null,
                'material'        => 'Plastic',
                'origin'          => 'Japan',
                'description'     => 'Remote-controlled fun toy car for kids.',
                'gallery_images'  => json_encode(['products/gallery/sample-2.jpg']),
                'extra_status'    => 'featured',
                'status'          => 'active',
                'created_at'      => Carbon::now(),
                'updated_at'      => Carbon::now(),
            ],
            [
                'name'            => 'Smart Fitness Watch',
                'sku'             => 'SKU-006',
                'barcode'         => '6789012345678',
                'image'           => 'products/sample-1.jpg',
                'cat_id'          => $categoryIds[5] ?? null,
                'brand_id'        => $brandIds[0] ?? null,
                'unit_id'         => $unitIds[0] ?? null,
                'color_id'        => $colorIds[1] ?? null,
                'purchase_price'  => 120.00,
                'discount'        => 4.00,
                'tax'             => 9.00,
                'price'           => 199,
                'offer_price'     => 179,
                'stock'           => 30,
                'alert_quantity'  => 8,
                'weight'          => '0.20 kg',
                'size_id'         => isset($sizeIds[0]) ? $sizeIds[0] : null,
                'material'        => 'Silicone',
                'origin'          => 'Korea',
                'description'     => 'Track all your daily activity with this smart watch.',
                'gallery_images'  => json_encode(['products/gallery/sample-3.jpg', 'products/gallery/sample-4.jpg']),
                'extra_status'    => 'featured',
                'status'          => 'active',
                'created_at'      => Carbon::now(),
                'updated_at'      => Carbon::now(),
            ],
            [
                'name'            => 'Cotton Summer Dress',
                'sku'             => 'SKU-007',
                'barcode'         => '7890123456789',
                'image'           => 'products/sample-2.jpg',
                'cat_id'          => $categoryIds[1] ?? null,
                'brand_id'        => $brandIds[2] ?? null,
                'unit_id'         => $unitIds[3] ?? null,
                'color_id'        => $colorIds[2] ?? null,
                'purchase_price'  => 50.00,
                'discount'        => 2.00,
                'tax'             => 7.00,
                'price'           => 89,
                'offer_price'     => 69,
                'stock'           => 40,
                'alert_quantity'  => 12,
                'weight'          => '0.35 kg',
                'size_id'         => isset($sizeIds[2]) ? $sizeIds[2] : null,
                'material'        => 'Cotton',
                'origin'          => 'India',
                'description'     => 'Lightweight and stylish summer dress.',
                'gallery_images'  => json_encode(['products/gallery/sample-5.jpg']),
                'extra_status'    => 'popular',
                'status'          => 'active',
                'created_at'      => Carbon::now(),
                'updated_at'      => Carbon::now(),
            ],
            [
                'name'            => 'Deluxe Nonstick Pan',
                'sku'             => 'SKU-008',
                'barcode'         => '8901234567890',
                'image'           => 'products/sample-3.jpg',
                'cat_id'          => $categoryIds[2] ?? null,
                'brand_id'        => $brandIds[3] ?? null,
                'unit_id'         => $unitIds[1] ?? null,
                'color_id'        => $colorIds[3] ?? null,
                'purchase_price'  => 25.00,
                'discount'        => 1.50,
                'tax'             => 4.00,
                'price'           => 49,
                'offer_price'     => 39,
                'stock'           => 80,
                'alert_quantity'  => 25,
                'weight'          => '1.20 kg',
                'size_id'         => isset($sizeIds[1]) ? $sizeIds[1] : null,
                'material'        => 'Aluminum',
                'origin'          => 'Vietnam',
                'description'     => 'Premium nonstick pan, great for daily cooking.',
                'gallery_images'  => json_encode(['products/gallery/sample-2.jpg', 'products/gallery/sample-3.jpg']),
                'extra_status'    => 'hot',
                'status'          => 'active',
                'created_at'      => Carbon::now(),
                'updated_at'      => Carbon::now(),
            ],
            [
                'name'            => 'Elegant Table Lamp',
                'sku'             => 'SKU-009',
                'barcode'         => '9012345678901',
                'image'           => 'products/sample-4.jpg',
                'cat_id'          => $categoryIds[3] ?? null,
                'brand_id'        => $brandIds[4] ?? null,
                'unit_id'         => $unitIds[2] ?? null,
                'color_id'        => $colorIds[4] ?? null,
                'purchase_price'  => 60.00,
                'discount'        => 3.00,
                'tax'             => 8.00,
                'price'           => 99,
                'offer_price'     => 89,
                'stock'           => 45,
                'alert_quantity'  => 9,
                'weight'          => '0.90 kg',
                'size_id'         => isset($sizeIds[2]) ? $sizeIds[2] : null,
                'material'        => 'Ceramic',
                'origin'          => 'USA',
                'description'     => 'Decorative table lamp for living and bedroom.',
                'gallery_images'  => json_encode(['products/gallery/sample-1.jpg', 'products/gallery/sample-4.jpg']),
                'extra_status'    => 'featured',
                'status'          => 'active',
                'created_at'      => Carbon::now(),
                'updated_at'      => Carbon::now(),
            ],
            [
                'name'            => 'Sporty Running Shoes',
                'sku'             => 'SKU-010',
                'barcode'         => '1122334455667',
                'image'           => 'products/sample-5.jpg',
                'cat_id'          => $categoryIds[1] ?? null,
                'brand_id'        => $brandIds[0] ?? null,
                'unit_id'         => $unitIds[0] ?? null,
                'color_id'        => $colorIds[0] ?? null,
                'purchase_price'  => 100.00,
                'discount'        => 5.00,
                'tax'             => 10.00,
                'price'           => 159,
                'offer_price'     => 139,
                'stock'           => 25,
                'alert_quantity'  => 6,
                'weight'          => '0.65 kg',
                'size_id'         => isset($sizeIds[0]) ? $sizeIds[0] : null,
                'material'        => 'Mesh',
                'origin'          => 'Vietnam',
                'description'     => 'Lightweight running shoes for sports and daily use.',
                'gallery_images'  => json_encode(['products/gallery/sample-3.jpg', 'products/gallery/sample-5.jpg']),
                'extra_status'    => 'featured',
                'status'          => 'active',
                'created_at'      => Carbon::now(),
                'updated_at'      => Carbon::now(),
            ],
        ];

        foreach ($products as $product) {
            Product::create($product);
        }
    }
}
