<?php

namespace Database\Seeders;

use App\Models\Expenses;
use Illuminate\Database\Seeder;

class ExpensesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $expenses = [
            [
                'expense_id'   => 'EXP-20240101-0001',
                'title'        => 'Office Supplies',
                'description'  => 'Purchased paper, pens, and notebooks for office.',
                'amount'       => 150.75,
                'date'         => '2024-01-01',
                'paid_to'      => 'Staples',
            ],
            [
                'expense_id'   => 'EXP-20240103-0002',
                'title'        => 'Electricity Bill',
                'description'  => 'Paid monthly electricity bill.',
                'amount'       => 320.50,
                'date'         => '2024-01-03',
                'paid_to'      => 'City Power Co',
            ],
            [
                'expense_id'   => 'EXP-20240105-0003',
                'title'        => 'Internet Charges',
                'description'  => 'Internet subscription fee for office.',
                'amount'       => 99.99,
                'date'         => '2024-01-05',
                'paid_to'      => 'Comcast',
            ],
            [
                'expense_id'   => 'EXP-20240109-0004',
                'title'        => 'Travel Expense',
                'description'  => 'Taxi fare for client meeting.',
                'amount'       => 45.00,
                'date'         => '2024-01-09',
                'paid_to'      => 'Yellow Cab',
            ],
            [
                'expense_id'   => 'EXP-20240111-0005',
                'title'        => 'Team Lunch',
                'description'  => 'Lunch with project team at Italian Bistro.',
                'amount'       => 200.00,
                'date'         => '2024-01-11',
                'paid_to'      => 'Italian Bistro',
            ],
            [
                'expense_id'   => 'EXP-20240113-0006',
                'title'        => 'Stationery Restock',
                'description'  => 'Restocked printer cartridges and folders.',
                'amount'       => 60.80,
                'date'         => '2024-01-13',
                'paid_to'      => 'Office Depot',
            ],
            [
                'expense_id'   => 'EXP-20240115-0007',
                'title'        => 'Water Bill',
                'description'  => 'Monthly water utility payment.',
                'amount'       => 77.60,
                'date'         => '2024-01-15',
                'paid_to'      => 'Water Authority',
            ],
            [
                'expense_id'   => 'EXP-20240121-0008',
                'title'        => 'Client Entertainment',
                'description'  => 'Hosted a dinner for client discussion.',
                'amount'       => 305.40,
                'date'         => '2024-01-21',
                'paid_to'      => 'River Restaurant',
            ],
            [
                'expense_id'   => 'EXP-20240122-0009',
                'title'        => 'Office Maintenance',
                'description'  => 'Repair and cleaning of office equipment.',
                'amount'       => 180.00,
                'date'         => '2024-01-22',
                'paid_to'      => 'CleanTech Services',
            ],
            [
                'expense_id'   => 'EXP-20240127-0010',
                'title'        => 'Software Subscription',
                'description'  => 'Monthly subscription for productivity tools.',
                'amount'       => 55.99,
                'date'         => '2024-01-27',
                'paid_to'      => 'Microsoft',
            ],
        ];

        foreach ($expenses as $expense) {
            Expenses::create($expense);
        }
    }
}
