<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Color;

class ColorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $colors = [
            [
                'name' => 'Red',
                'status' => 'active',
            ],
            [
                'name' => 'Blue',
                'status' => 'active',
            ],
            [
                'name' => 'Green',
                'status' => 'active',
            ],
            [
                'name' => 'Yellow',
                'status' => 'active',
            ],
            [
                'name' => 'Orange',
                'status' => 'active',
            ],
            [
                'name' => 'Black',
                'status' => 'inactive',
            ],
            [
                'name' => 'White',
                'status' => 'active',
            ],
            [
                'name' => 'Purple',
                'status' => 'inactive',
            ],
            [
                'name' => 'Pink',
                'status' => 'active',
            ],
            [
                'name' => 'Brown',
                'status' => 'inactive',
            ]
        ];

        foreach ($colors as $color) {
            Color::create($color);
        }
    }
}
