<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Banner;
use Faker\Factory as Faker;

class BannerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Faker::create();

        for ($i = 1; $i <= 10; $i++) {
            Banner::create([
                'image' => 'banners/banner-' . $i . '.jpg',
                'title' => $faker->words(3, true),
                'subtitle' => $faker->sentence(4, true),
                'description' => $faker->sentence(8, true),
                'btn_name' => $faker->randomElement(['Learn More', 'Shop Now', 'Discover', 'Get Started', 'View Details', 'Buy Now']),
                'btn_link' => $faker->url(),
                'status' => $faker->randomElement(['active', 'inactive']),
            ]);
        }
    }
}
