<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;

class UserController extends Controller
{
    public function index()
    {
        // Eager load 'role' relationship and get all user data
        $users = User::with('role')->get();

        // Transform each user: include all original attributes plus role name (for convenience)
        $usersTransformed = $users->map(function ($user) {
            $userData = $user->toArray();
            // Attach role_name as a top-level property (null if no role)
            $userData['role_name'] = $user->role ? $user->role->name : null;
            return $userData;
        });

        return response()->json(['users' => $usersTransformed], 200);
    }
}
