<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class DefaultDataSeeder extends Seeder
{
    public function run(): void
    {
        // -------------------------------
        // Insert default roles
        // -------------------------------
        DB::table('roles')->insert([
            ['name' => 'admin'],
            ['name' => 'user'],
        ]);

        // -------------------------------
        // Insert default permissions
        // -------------------------------
        DB::table('permissions')->insert([
            ['name' => 'manage_users'],
            ['name' => 'manage_roles'],
            ['name' => 'view_dashboard'],
        ]);

        // -------------------------------
        // Assign permissions to roles
        // -------------------------------
        // admin gets all permissions
        $adminRoleId = DB::table('roles')->where('name', 'admin')->value('id');
        $allPermissionIds = DB::table('permissions')->pluck('id');

        foreach ($allPermissionIds as $permId) {
            DB::table('permission_role')->insert([
                'role_id' => $adminRoleId,
                'permission_id' => $permId,
            ]);
        }

        // user gets only view_dashboard
        $userRoleId = DB::table('roles')->where('name', 'user')->value('id');
        $dashboardPermissionId = DB::table('permissions')->where('name', 'view_dashboard')->value('id');

        DB::table('permission_role')->insert([
            'role_id' => $userRoleId,
            'permission_id' => $dashboardPermissionId,
        ]);

        // -------------------------------
        // Insert default users
        // -------------------------------
        DB::table('admins')->insert([
            [
                'name' => 'Admin User',
                'email' => 'admin@example.com',
                'password' => Hash::make('password123'), // secure your password
                'role_id' => '1',
            ]
        ]);

        // -------------------------------
        // Insert default users
        // -------------------------------
        DB::table('users')->insert([
            [
                'name' => 'Regular User',
                'email' => 'user@example.com',
                'password' => Hash::make('password123'),
            ]
        ]);

        $this->command->info('Default roles, permissions, and users seeded!');
    }
}
