<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('admins', function (Blueprint $table) {
            $table->string('profile_image')->nullable()->after('email');
            $table->string('phone')->nullable()->after('profile_image');
            $table->string('address')->nullable()->after('phone');
            $table->string('dob')->nullable()->after('address');
            $table->enum('gender', ['male', 'female', 'other'])->nullable()->after('dob');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('admins', function (Blueprint $table) {
            //
        });
    }
};
